var rgv_values = [
	{folder: 'rgv_1', text: '1.0'},
	{folder: 'rgv_0_9', text: '0.9'},
	{folder: 'rgv_0_8', text: '0.8'},
	{folder: 'rgv_0_7', text: '0.7'},
	{folder: 'rgv_0_6', text: '0.6'},
	{folder: 'rgv_0_5', text: '0.5'},
	{folder: 'rgv_0_4', text: '0.4'},
	{folder: 'rgv_0_3', text: '0.3'},
	{folder: 'rgv_0_2', text: '0.2'},
	{folder: 'rgv_0_1', text: '0.1'},
	{folder: 'rgv_0_05', text: '0.05'},
];

var mom2_values = [
	{folder: 'mom2_1', text: '1.0'},
	{folder: 'mom2_0_8', text: '0.8'},
	{folder: 'mom2_0_6', text: '0.6'},
	{folder: 'mom2_0_4', text: '0.4'},
	{folder: 'mom2_0_2', text: '0.2'},
];

var mom3_values = [
	{folder: 'mom3_1', text: '1.0'},
	{folder: 'mom3_0_8', text: '0.8'},
	{folder: 'mom3_0_6', text: '0.6'},
	{folder: 'mom3_0_4', text: '0.4'},
	{folder: 'mom3_0_2', text: '0.2'},
];

var mom4_values = [
	{folder: 'mom4_1', text: '1.0'},
	{folder: 'mom4_0_8', text: '0.8'},
	{folder: 'mom4_0_6', text: '0.6'},
	{folder: 'mom4_0_4', text: '0.4'},
	{folder: 'mom4_0_2', text: '0.2'},
];

var lhm_values = [
	{folder: 'lhm_1', text: '1.0'},
	{folder: 'lhm_0_9', text: '0.9'},
	{folder: 'lhm_0_8', text: '0.8'},
	{folder: 'lhm_0_7', text: '0.7'},
	{folder: 'lhm_0_6', text: '0.6'},
	{folder: 'lhm_0_5', text: '0.5'},
	{folder: 'lhm_0_4', text: '0.4'},
	{folder: 'lhm_0_3', text: '0.3'},
	{folder: 'lhm_0_2', text: '0.2'},
	{folder: 'lhm_0_1', text: '0.1'},
	{folder: 'lhm_0_05', text: '0.05'},
];

var lpm_values = [
	{folder: 'lpm_1', text: '1.0'},
	{folder: 'lpm_0_9', text: '0.9'},
	{folder: 'lpm_0_8', text: '0.8'},
	{folder: 'lpm_0_7', text: '0.7'},
	{folder: 'lpm_0_6', text: '0.6'},
	{folder: 'lpm_0_5', text: '0.5'},
	{folder: 'lpm_0_4', text: '0.4'},
	{folder: 'lpm_0_3', text: '0.3'},
	{folder: 'lpm_0_2', text: '0.2'},
	{folder: 'lpm_0_1', text: '0.1'},
	{folder: 'lpm_0_05', text: '0.05'},
];


var MAX_ZOOM = 8;
var MIN_ZOOM = -10;
var current_file_index = 0;
var current_rgv = 2;
var current_mom2 = 2;
var current_mom3 = 2;
var current_mom4 = 2;
var current_lhm = 0;
var current_lpm = 0;
var current_zoom = 0;
var current_strip_folders = false;
var current_tiled = false;
var current_dataset = 0;
var current_algorithm = 'default';

function getFileName()
{
	return datasets[current_dataset].files[current_file_index].file_name;
}

function reloadImages()
{
	var dataset = datasets[current_dataset];
	var file = dataset.files[current_file_index];

	// Show nice name
	$('#file_name').html(dataset.name + '<br>' + file.name + '<br>' + file.file_name);

	// set source
	source_image_path = '../sources_jpg/' + dataset.id + '/' + file.file_name + '.jpg';
	$('#source_image').attr('src', source_image_path);
	$('#download_exemplar_link').attr('href', source_image_path);


	// set result
	var result_folder = current_algorithm;
	if (current_algorithm == 'rgv') result_folder = rgv_values[current_rgv].folder;
	else if (current_algorithm == 'mom2') result_folder = mom2_values[current_mom2].folder;
	else if (current_algorithm == 'mom3') result_folder = mom3_values[current_mom3].folder;
	else if (current_algorithm == 'mom4') result_folder = mom4_values[current_mom4].folder;
	else if (current_algorithm == 'lhm') result_folder = lhm_values[current_lhm].folder;
	else if (current_algorithm == 'lpm') result_folder = lpm_values[current_lpm].folder;

	// bits = [];
	// if (current_rgv > 0) bits.push();
	// if (current_lhm > 0) bits.push(lhm_values[current_lhm].folder);
	// if (bits.length > 0) folder = bits.join('_');
	// else folder = 'default';

	var result_image_path = '../results_jpg/' + dataset.id + '/' + result_folder + '/' + file.file_name + '.jpg';
	if (current_algorithm == 'none') result_image_path = '../sources_jpg/' + dataset.id + '/' + file.file_name + '.jpg';
	$('#result_image').css('background-image', 'url(' + result_image_path + ')');
	$('#download_result_link').attr('href', result_image_path);

	// if (current_strip_folders) updateStrip();
	// updateTiled();
}

function previousDataSet()
{
	current_dataset--;
	if (current_dataset < 0) current_dataset = datasets.length - 1;
	current_file_index = datasets[current_dataset].files.length - 1;
}

function nextDataSet()
{
	current_dataset++;
	if (current_dataset >= datasets.length) current_dataset = 0;
	current_file_index = 0;
}

function previousImage()
{
	current_file_index--;
	if (current_file_index < 0) previousDataSet();
	reloadImages();
}

function nextImage()
{
	current_file_index++;
	if (current_file_index >= datasets[current_dataset].files.length) nextDataSet();
	reloadImages();
}

function setRGV(index)
{
	if (current_algorithm != 'rgv')
	{
		setAlgorithm('rgv');
		return;
	}
	$('#rgv').val(index);
	current_rgv = +$('#rgv').val();
	$('#rgv_text').text('Window size: ' + rgv_values[current_rgv].text);
	reloadImages();
}

function setMom2(index)
{
	if (current_algorithm != 'mom2')
	{
		setAlgorithm('mom2');
		return;
	}
	$('#mom2').val(index);
	current_mom2 = +$('#mom2').val();
	$('#mom2_text').text('Window size: ' + mom2_values[current_mom2].text);
	reloadImages();
}

function setMom3(index)
{
	if (current_algorithm != 'mom3')
	{
		setAlgorithm('mom3');
		return;
	}
	$('#mom3').val(index);
	current_mom3 = +$('#mom3').val();
	$('#mom3_text').text('Window size: ' + mom3_values[current_mom3].text);
	reloadImages();
}

function setMom4(index)
{
	if (current_algorithm != 'mom4')
	{
		setAlgorithm('mom4');
		return;
	}
	$('#mom4').val(index);
	current_mom4 = +$('#mom4').val();
	$('#mom4_text').text('Window size: ' + mom4_values[current_mom4].text);
	reloadImages();
}


function setLHM(index)
{
	if (current_algorithm != 'lhm')
	{
		setAlgorithm('lhm');
		return;
	}
	$('#lhm').val(index);
	current_lhm = +$('#lhm').val();
	$('#lhm_text').text('Window size: ' + lhm_values[current_lhm].text);
	reloadImages();
}

function setLPM(index)
{
	if (current_algorithm != 'lpm')
	{
		setAlgorithm('lpm');
		return;
	}
	$('#lpm').val(index);
	current_lpm = +$('#lpm').val();
	$('#lpm_text').text('Window size: ' + lpm_values[current_lpm].text);
	reloadImages();
}

function setZoom(index)
{
	$('#zoom').val(index);
	current_zoom = +$('#zoom').val();
	z = 2300 + current_zoom * 100;
	$('#result_image').css('transform', 'rotateX( 30deg ) translateX(-2000px) translateY(-2500px) translateZ(' + z + 'px)');
	// z = 2200 + current_zoom * 100;
	// $('#result_image').css('transform', 'rotateX( 28deg ) translateX(-2000px) translateY(-2500px) translateZ(' + z + 'px)');
	$('#zoom_text').text('Zoom: ' + current_zoom);
}

function zoomBy(amount)
{
	setZoom(current_zoom + amount);
}

function setAlgorithm(algorithm)
{
	current_algorithm = algorithm;
	reloadImages();

	rgv_visible = current_algorithm == 'rgv' ? 'block' : 'none';
	mom2_visible = current_algorithm == 'mom2' ? 'block' : 'none';
	mom3_visible = current_algorithm == 'mom3' ? 'block' : 'none';
	mom4_visible = current_algorithm == 'mom4' ? 'block' : 'none';
	lhm_visible = current_algorithm == 'lhm' ? 'block' : 'none';
	lpm_visible = current_algorithm == 'lpm' ? 'block' : 'none';
	$('#rgv_control').css('display', rgv_visible);
	$('#mom2_control').css('display', mom2_visible);
	$('#mom3_control').css('display', mom3_visible);
	$('#mom4_control').css('display', mom4_visible);
	$('#lhm_control').css('display', lhm_visible);
	$('#lpm_control').css('display', lpm_visible);

	$('#algorithm').val(algorithm);
}




$(document).keypress(function(event) {
	console.log("Pressed: " + event.key);
	if (event.key == 'n') nextImage();
	if (event.key == 'p') previousImage();
	if (event.key == 'r') setRGV(current_rgv + 1);
	if (event.key == 'R') setRGV(current_rgv - 1);
	if (event.key == 'l') setLHM(current_lhm + 1);
	if (event.key == 'L') setLHM(current_lhm - 1);
	if (event.key == 's') setLPM(current_lpm + 1);
	if (event.key == 'S') setLPM(current_lpm - 1);
	if (event.key == '+') zoomBy(1);
	if (event.key == '=') zoomBy(1);
	if (event.key == '-') zoomBy(-1);
	if (event.key == '_') zoomBy(-1);
	if (event.key == 'c') setAlgorithm('make_tileable');
	if (event.key == 'g') setAlgorithm('gimp');
	if (event.key == 'u') setAlgorithm('weight_map_lu09');
	if (event.key == 'd') setAlgorithm('default');
});

$(document).ready(function(event) {
	setRGV($('#rgv').val());
	setRGV($('#rgv').val());
	setMom2($('#mom2').val());
	setMom2($('#mom2').val());
	setMom3($('#mom3').val());
	setMom3($('#mom3').val());
	setMom4($('#mom4').val());
	setMom4($('#mom4').val());
	setLPM($('#lpm').val());
	setLPM($('#lpm').val());
	setLHM($('#lhm').val());
	setLHM($('#lhm').val());
	setZoom(0);
	setAlgorithm($('#algorithm').val());
	reloadImages();
});


function showLicense() {
	var text = 'This website is supplemental material to the Eurographics 2017 paper. If you end up using any of the data on this website for research, please reference the paper.';
	var official_text = 'This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License. To view a copy of this license, visit <a href="http://creativecommons.org/licenses/by-nc-sa/4.0/">http://creativecommons.org/licenses/by-nc-sa/4.0/</a> or send a letter to Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.';
	text += '<br><br>' + official_text;
	$('#file_name').html(text);
	$('#source_image').attr('src', '');
}
