import os.path
import numpy



class Shuttle_AL:
  """Provides an interface to the shuttle data, which is naturally heavilly biased."""
  def __init__(self):
    directory = os.path.dirname(os.path.abspath(__file__))

    train = open(os.path.join(directory, 'shuttle_subset.trn'),'r').readlines()
    self.trainVec = numpy.empty((len(train),9), dtype=numpy.float32)
    self.trainAns = numpy.empty(len(train), dtype=numpy.uint8)

    for i,d in enumerate(train):
      dd = map(int, d.split())
      for j in xrange(9):
        self.trainVec[i,j] = dd[j]
      self.trainAns[i] = dd[9]

    test = open(os.path.join(directory, 'shuttle.tst'),'r').readlines()
    self.testVec = numpy.empty((len(test),9), dtype=numpy.float32)
    self.testAns = numpy.empty(len(test), dtype=numpy.uint8)

    for i,d in enumerate(test):
      dd = map(int, d.split())
      for j in xrange(9):
        self.testVec[i,j] = dd[j]
      self.testAns[i] = dd[9]


  def getTrainVectors(self):
    """Returns the trainning vectors - a numpy array of float32, where each vector is [i,:]."""
    return self.trainVec

  def getTrainClasses(self):
    """Returns the class represented by each trainning vector - a numpy array of uint8, indexed by [i]."""
    return self.trainAns

  def getTestVectors(self):
    """Returns the test vectors - a numpy array of float32, where each vector is [i,:]."""
    return self.testVec

  def getTestClasses(self):
    """Returns the class represented by each test vector - a numpy array of uint8, indexed by [i]."""
    return self.testAns
