#! /usr/bin/env python

import numpy
import scipy.io



# Load the data...
data = scipy.io.loadmat('shuttle_results.mat', struct_as_record=True)

classes = data['discover_iter']
inliers = data['classify_iter']

# Write Tim's stuff...
f = open('tim.csv','w')
f.write('querys, mean classes found, mean inlier rate\n')
f.write('0, 0.0, 0.0\n')
f.write('1, 1.0, -\n')

for i in xrange(classes.shape[1]):
  ii = i+2
  cla = classes[0,i]* 7.0
  inl = inliers[0,i]
  f.write('%i, %f, %f\n'%(ii, cla, inl))

f.close()



# Write the 3 other sets of results in the file...
names = ['vatturi', 'pelleg', 'he']

for name in names:
  classes = data['other_'+name]

  f = open(name+'.csv','w')
  f.write('querys, classes found\n')

  for i in xrange(classes.shape[0]):
    f.write('%i, %i\n'%(round(classes[i,0]), round(classes[i, 1])))

  f.close()
