#!/bin/bash

# Create the relevent configuration file...
echo "<?xml version=\"1.0\"?>" > sfgs_config.xml
echo "<sfgs>" >> sfgs_config.xml
echo "<disparity min=\"-15\" max=\"15\" scale=\"16\"/>" >> sfgs_config.xml
echo "<iterations value=\"1\"/>" >> sfgs_config.xml
echo "<light left=\"(0,0,1)\" right=\"(0,0,1)\"/>" >> sfgs_config.xml
echo "<shape>" >> sfgs_config.xml
echo "<match out-of-bound=\"0.0\">" >> sfgs_config.xml
echo "<alpha mult=\"$1\" max=\"1.0\"/>" >> sfgs_config.xml
echo "<beta mult=\"$2\" max=\"1.0\"/>" >> sfgs_config.xml
echo "<gamma mult=\"$3\" max=\"1.0\"/>" >> sfgs_config.xml
echo "</match>" >> sfgs_config.xml
echo "<diff error=\"0.1\"/>" >> sfgs_config.xml
echo "<smooth min=\"0.5\" sd=\"2.0\"/>" >> sfgs_config.xml
echo "</shape>" >> sfgs_config.xml
echo "<albedo labels=\"100\">" >> sfgs_config.xml
echo "<sfs sd=\"1.0\" min=\"0.2\" angle=\"0.314\"/>" >> sfgs_config.xml
echo "<neighbour sd=\"1.0\" min=\"0.2\" alpha=\"0.05\" beta=\"0.05\"/>" >> sfgs_config.xml
echo "</albedo>" >> sfgs_config.xml
echo "</sfgs>" >> sfgs_config.xml

# Create the output directory...
mkdir $1_$2_$3

# Run the program...
LD_LIBRARY_PATH=..
export LD_LIBRARY_PATH

cd $1_$2_$3
../sfgs ../nose_left.bmp ../nose_right.bmp ../nose.pcc ../sfgs_config.xml
cd ..
