import subprocess

from direct.showbase import DirectObject
from pandac.PandaModules import *

class Profile(DirectObject.DirectObject):
  """Connects to pstats, if pstats is not running on the local computer it will set a copy running regardless."""
  def __init__(self,manager,xml):
    self.pstats = None

  def go(self):
    if (PStatClient.connect()==0):
      # No pstat server - create it, then try and connect again...
      self.pstats = subprocess.Popen(['pstats'])

      # Need to give pstats some time to warm up - use a do latter task...
      def tryAgain(task):
        PStatClient.connect()
      taskMgr.doMethodLater(0.5,tryAgain,'pstats again')

  def start(self):
    self.accept('f10',self.go)

  def stop(self):
    self.ignore('f10')

  def reload(self,manager,xml):
    pass

  def destroy(self):
    if self.pstats!=None:
      self.pstats.kill()
