from pandac.PandaModules import *
import direct.directbase.DirectStart


class MouseFPS:
  """Provides fps style mouse control, sending the data to arbitary nodes"""
  def __init__(self,manager,xml):
    # First get rid of the mouse cursor...
    props = WindowProperties()
    props.setCursorHidden(True)
    base.win.requestProperties(props)

    # Variables needed by mouse simulation...
    self.originX = 0
    self.originY = 0
    self.speed = 0.1
    self.minY = -45.0
    self.maxY = 45.0
    
    speed = xml.find('speed')
    if speed!=None:
      self.speed = float(speed.get('val'))
    
    # Get the nodes to be updated by the mouse movement...
    xRot = xml.find('x-rot')
    if xRot!=None:
      self.xNode = manager.get(xRot.get('plugin')).getNode(xRot.get('node'))
    else:
      self.xNode = None

    yRot = xml.find('y-rot')
    if yRot!=None:
      self.yNode = manager.get(yRot.get('plugin')).getNode(yRot.get('node'))
      self.maxY = float(yRot.get('max'))
      self.minY = float(yRot.get('min'))
    else:
      self.yNode = None

    # Set the mouse task going...
    taskMgr.add(self.mouseTask,'Mouse',sort=-100)


  def mouseTask(self,task):
    md = base.win.getPointer(0)
    ox = md.getX() - self.originX
    oy = md.getY() - self.originY
    self.originX = md.getX()
    self.originY = md.getY()

    # The if statement is not necessary - it exists so if you start the program with the mouse cursor outside the window and then move it into the window the camera will not jerk. It of course could prevent really fast rotation in game.
    if abs(ox)<base.win.getXSize()//3 and abs(oy)<base.win.getYSize()//3:
      if self.xNode: self.xNode.setH(self.xNode.getH() - ox*self.speed)
      if self.yNode: self.yNode.setP(min(max(self.yNode.getP() - oy*self.speed,self.minY),self.maxY))

    xoob = self.originX<base.win.getXSize()//4 or self.originX>(base.win.getXSize()*3)//4
    yoob = self.originY<base.win.getYSize()//4 or self.originY>(base.win.getYSize()*3)//4
    if xoob or yoob:
      cx = base.win.getXSize()//2
      cy = base.win.getYSize()//2
      if base.win.movePointer(0,cx,cy):
        self.originX = cx
        self.originY = cy

    return task.cont