from pandac.PandaModules import *
import direct.directbase.DirectStart


class DirLight:
  """Creates a simple directional light"""
  def __init__(self,manager,xml):
    self.light = DirectionalLight('light')

    color = xml.find('color')
    if color!=None:
      self.light.setColor(VBase4(float(color.get('r')),float(color.get('g')),float(color.get('b')),1.0))

    self.lightNode = render.attachNewNode(self.light)

    pos = xml.find('pos')
    if pos!=None:
      self.lightNode.setPos(float(pos.get('x')),float(pos.get('y')),float(pos.get('z')))

    lookAt = xml.find('lookAt')
    if lookAt!=None:
      self.lightNode.lookAt(float(lookAt.get('x')),float(lookAt.get('y')),float(lookAt.get('z')))

    render.setLight(self.lightNode)