import math

from pandac.PandaModules import *


def nearestHit(space,ray):
  """Collides the given ray with the space provided by the ode module - returns (None,None) if it fails to hit anything or a tuple of (geom,position) of the closest point that it does hit."""
  bestGeom = None
  bestPos = None
  bestMan = None

  rayPos = ray.getPosition()

  for i in xrange(space.getNumGeoms()):
    geom = space.getGeom(i)

    testA = (geom.getCollideBits() & ray.getCollideBits()).isZero()
    testB = (ray.getCollideBits() & geom.getCollideBits()).isZero()
    if (not testA) or (not testB):
      cc = OdeUtil.collide(ray,geom)
      for j in xrange(cc.getNumContacts()):
        contact = cc.getContact(j)
        pos = contact.getGeom().getPos()

        man = sum(map(lambda i: abs(pos[i]-rayPos[i]),xrange(3)))
        if (bestMan==None) or (man<bestMan):
          bestGeom = geom
          bestPos = pos
          bestMan = man

  return (bestGeom,bestPos)