#! /usr/bin/env python3

import sys
import os
import shutil

import argparse
import csv



# Handle command line arguments...
parser = argparse.ArgumentParser(description='Given the output of the mark_dir.py script followed by a Moodle mark spreadsheet this merges them, replacing the old Moodle mark spreadsheet with a new one (makes a backup). Fussy about Moodle spreadsheet, but flexible with mark_dir output, so it can handle editting during the checking phase (requires Participant and Total columns to still exist and be valid).')

parser.add_argument('marks', help='The marks csv file output by the mark_dir.py script (possibly editted).')
parser.add_argument('moodle', help='The Moodle generated csv file.')


args = parser.parse_args()



# Open marks spreadsheet, and create a participant to mark dictionary...
marks = {}
feedback = {}

with open(args.marks, 'r', newline='') as fin:
  first = True
  for row in csv.reader(fin):
    if first:
      participant = row.index('Participant')
      total = row.index('Total')
      try:
        fback = row.index('Feedback')
      except ValueError:
        fback = None
      first = False
      
      print('column(Particpant) = {}'.format(participant))
      print('column(Total) = {}'.format(total))
    
    else:
      marks[row[participant]] = row[total]
      if fback is not None and len(row[fback])>0:
        feedback[row[participant]] = row[fback]

print('Marks found = {}'.format(len(marks)))



# Open moodle spreadsheet, and generate a new set of rows...
output = []
used = 0
used_fb = 0

with open(args.moodle, 'r', newline='', encoding='utf-8-sig') as fin:
  first = True
  for row in csv.reader(fin):
    if first:
      assert(len(row)==8)
      assert(row[0]=='Identifier')
      assert(row[1]=='Status')
      assert(row[2]=='Grade')
      assert(row[3]=='Maximum Grade')
      assert(row[4]=='Grade can be changed')
      assert(row[5]=='Last modified (submission)')
      assert(row[6]=='Last modified (grade)')
      assert(row[7]=='Feedback comments')
      first = False
      output.append(row)
    
    else:
      _, pid = row[0].split()
      
      if pid in marks:
        row[2] = marks[pid]
        used += 1
      
      if pid in feedback:
        row[7] = feedback[pid]
        used_fb += 1
      
      output.append([r.strip() for r in row])



# Safety checks...
if used!=len(marks):
  print('Error: Did not use all marks (used {})'.format(used))
  sys.exit(1)

if used_fb!=len(feedback):
  print('Error: Did not use all feedback (used {})'.format(used_fb))
  sys.exit(1)



# Make backup of old file...
shutil.copyfile(args.moodle, args.moodle+'~')



# Overwrite moodle file with new version...
with open(args.moodle, 'w', newline='') as fout:
  writer = csv.writer(fout)
  
  for row in output:
    writer.writerow(row)

print('Done.')
