# Automarker 2 - This time it's not random
(by Tom Haines, title suggested by Neill Campbell)

No documentation, so look at the examples! Feature set uneven, as it's driven by what I need at any given moment.

At a high level, the marking scripts print the mark for a single piece of coursework to the console (broken down by question). The `mark_dir.py` runs this script on the directory structure downloaded from Moodle and collects them all into a spreadsheet, for a human to check/add feedback to etc. `to_moodle.py` then does what you would expect.

The `automark.py` library provides an object to support marking by loading and running a Jupyter `Notebook`. You then construct and configure `Question` objects, and run them as a functor on the `Notebook`; they then print the marks to the console in the right format. Questions are very configurable, but fundamentally come down to judges. Each `Judge` when run can analyse any part of the Jupyter workbook, and returns `False` (fail), `True` (pass) or `None` (don't know - human needs to check). Judges are actually functions or functors, so you can just write them yourself raw, using the `Cell` interface (a `Notebook` is effectively a list of them), though the library provides many built in judges for common situations.

Finally, at the end of semester, the `Samis` object in the `samis.py` library lets you configure transfer into the spreadsheet that we get emailed.



## Libraries

* `automark2.py` - Automarking system, as single file
* `samis.py` - Library for converting Moodle spreadsheet to samis



## Scripts

* `mark_dir.py` - Marks all coursework in a directory and collates marks into spreadsheet
* `to_moodle.py` - Merges the spreadsheet output by `mark_dir.py` into a Moodle spreadsheet
* `dont_mark_dir.py` - Generates the same spreadsheet as `mark_dir.py`, but without doing any marking, just by looking at folder names. Lets you use the same pipeline when it's a directory of essays.



## Examples

* `ML1_L04.py`
* `STfDS_L02.py`
* `STfDS_L03.py`
* `STfDS_L04.py`
* `STfDS_to_samis` - This one demos the `samis.py` library


## Unit tests

* `instrument_test.py` - Checks the `for` loop counting code works
* `judge_exam.py` - Some unit tests for judges

