#! /usr/bin/env python3

import unittest
import automark2 as am



class TestCodeDeclares(unittest.TestCase):
  
  def test_simple(self):
    code = "a = 8\nb = 4\nc = 'hello'"
    cell = am.Cell(0, code)
    
    judge_pass = am.CodeDeclares('b')
    self.assertTrue(judge_pass(cell))
    
    judge_fail = am.CodeDeclares('d')
    self.assertFalse(judge_fail(cell))
  
  
  def test_within(self):
    code = "for i in range(6):\n  blah = i\n"
    cell = am.Cell(0, code)
    
    judge = am.CodeDeclares('blah')
    self.assertTrue(judge(cell))
  
  
  def test_slice(self):
    code = "turnip[:] = 9"
    cell = am.Cell(0, code)
    
    judge = am.CodeDeclares('turnip')
    self.assertFalse(judge(cell))



class TestCodeNoLoops(unittest.TestCase):
  
  def test_none(self):
    code = "a = 6\nif a%2==0:\n  print('Hello')"
    cell = am.Cell(0, code)
    
    judge = am.CodeNoLoops()
    self.assertTrue(judge(cell))


  def test_for(self):
    code = "a = 6\nif a%2==0:\n  for i in range(4):\n    print(i)"
    cell = am.Cell(0, code)
    
    judge = am.CodeNoLoops()
    self.assertFalse(judge(cell))


  def test_while(self):
    code = "i = 0\nwhile i<6:\n  print(i)\n  i += 1"
    cell = am.Cell(0, code)
    
    judge = am.CodeNoLoops()
    self.assertFalse(judge(cell))



class TestCodeAssignCall(unittest.TestCase):
  
  def test_simple(self):
    code = "a = func(1, 2)"
    cell = am.Cell(0, code)
    
    judge = am.CodeAssignCall('a', 'func')
    self.assertTrue(judge(cell))
    
    judge = am.CodeAssignCall('a', 'other')
    self.assertFalse(judge(cell))
    
    judge = am.CodeAssignCall('b', 'func')
    self.assertFalse(judge(cell))
  
  
  def test_module(self):
    code = "a = module.func(1, 2)"
    cell = am.Cell(0, code)
    
    judge = am.CodeAssignCall('a', 'func')
    self.assertTrue(judge(cell))
    
    judge = am.CodeAssignCall('a', 'other')
    self.assertFalse(judge(cell))
    
    judge = am.CodeAssignCall('b', 'func')
    self.assertFalse(judge(cell))


  def test_submodule(self):
    code = "a = module.submodule.func(1, 2)"
    cell = am.Cell(0, code)
    
    judge = am.CodeAssignCall('a', 'func')
    self.assertTrue(judge(cell))
    
    judge = am.CodeAssignCall('a', 'other')
    self.assertFalse(judge(cell))
    
    judge = am.CodeAssignCall('b', 'func')
    self.assertFalse(judge(cell))



  def test_slice(self):
    code = "a[:] = func('wibble')"
    cell = am.Cell(0, code)
    
    judge = am.CodeAssignCall('a', 'func')
    self.assertTrue(judge(cell))
    
    judge = am.CodeAssignCall('a', 'other')
    self.assertFalse(judge(cell))
    
    judge = am.CodeAssignCall('b', 'func')
    self.assertFalse(judge(cell))



if __name__ == '__main__':
    unittest.main()
