#! /usr/bin/env python3

from collections import defaultdict
from automark2 import instrument_loops



# No-op...
@instrument_loops
def hello():
  print('Hello')

counts = defaultdict(int)
hello(loops=counts)
print(counts)



# One loop...
@instrument_loops
def counting():
  print('Counting')
  for i in range(8):
    pass

counts = defaultdict(int)
counting(loops=counts)
print(counts)



# Two loops...
@instrument_loops
def counting():
  print('Double')
  for i in range(6):
    for j in range(4):
      pass

counts = defaultdict(int)
counting(loops=counts)
print(counts)