#! /usr/bin/env python3

import sys
import os

import argparse



# Handle command line arguments...
parser = argparse.ArgumentParser(description='Generates the same spreadsheet as mark_dir.py, but without doing any automarking. You can then add your own sub-mark columns. Just conveniant in terms of automatic extraction of particpant numbers from the directories and ordering them sensibly, then being compatable with the other scrips.')

parser.add_argument('directory', help='Directory as downloaded from Moodle, where every subdirectory is a different student.')

parser.add_argument('output', help='Output csv file that contains all of the marks. Defaults to the same as the script file but with a csv extension.', nargs='?', default=None)

args = parser.parse_args()

if args.output is None:
  args.output = 'marks.csv'



# Bug out if output exists...
if os.path.exists(args.output):
  print('Critical: Output file already exists')
  sys.exit(1)



# Get contents of directory...
sids = [] # Student id

prefix = 'Participant_'
for de in os.scandir(args.directory):
  if de.is_dir() and de.name.startswith(prefix):
    end = de.name.index('_', len(prefix))
    sid = int(de.name[len(prefix):end])
    
    sids.append(sid)

sids.sort()
print('Info: Found {} directories of coursework'.format(len(sids)))



# Generate spreadsheet...
with open(args.output, 'w') as fout:
  fout.write('Participant, Total, Checked, Feedback\n')
  
  for sid in sids:
    fout.write(f'{sid},,,\n')
