#! /usr/bin/env python3

import automark2 as am



# Load code...
notebook = am.Notebook(cwd='../Software Technologies for Data Science/Labs/04 - Sudoku')



# Q1 - Bugs!..

# Syntax error...
syn_right = """
if r==row:
  continue
if self.allowed[r, col, remain]:
  self.remove(r, col, remain+1)
"""

q1_01 = am.Question('1.01', 1)
q1_01.add(None, am.CodeDelta(None, syn_right))
q1_01(notebook)


# Typo...
typo_wrong = """
remain = numpy.nonzero(self.allowed[row, col, :])[0][0]
            
for r in range(8):
  if r==row:
    continue
"""

typo_right = """
remain = numpy.nonzero(self.allowed[row, col, :])[0][0]
            
for r in range(9):
  if r==row:
    continue
"""

q1_02 = am.Question('1.02', 1)
q1_02.add(None, am.CodeDelta(typo_wrong, typo_right))
q1_02(notebook)


# Off by one 1...
obo1_wrong = """
if s[offset]!='0':
  value = int(s[offset])
  for val in range(9):
    if val==value:
      continue
"""

obo1_right = """
if s[offset]!='0':
  value = int(s[offset])
  for val in range(1,10):
    if val==value:
      continue
"""

q1_03 = am.Question('1.03', 1)
q1_03.add(None, am.CodeDelta(obo1_wrong, obo1_right))
q1_03(notebook)


# Off by one 2 & Contract violation 1...
obo2_wrong = """
row, col = [axis[0] for axis in numpy.nonzero(counts == lowest)]
choices = numpy.nonzero(self.allowed[row, col, :])
return row, col, choices
"""

obo2_right = """
row, col = [axis[0] for axis in numpy.nonzero(counts == lowest)]
choices = numpy.nonzero(self.allowed[row, col, :])[0] + 1
return row, col, choices
"""

q1_0408 = am.Question('1.04/08', 2)
q1_0408.worth(None, 2)
q1_0408.add(None, am.CodeDelta(obo2_wrong, obo2_right))
q1_0408(notebook)


# Logic error 1...
le1_wrong = """
return numpy.all(self.allowed.sum(axis=2)==0)
"""

le1_right = """
return numpy.all(self.allowed.sum(axis=2)==1)
"""

q1_05 = am.Question('1.05', 1)
q1_05.add(None, am.CodeDelta(le1_wrong, le1_right))
q1_05(notebook)


# Logic error 2...
le2_wrong = """
for c in range(*self.__square[col].indices(9)):
  if self.allowed[r, c, remain]:
    self.remove(r, c, remain+1)
"""

le2_right = """
for c in range(*self.__square[col].indices(9)):
  if r==row and c==col:
    continue
  if self.allowed[r, c, remain]:
    self.remove(r, c, remain+1)
"""

q1_06 = am.Question('1.06', 1)
q1_06.add(None, am.CodeDelta(le2_wrong, le2_right))
q1_06(notebook)


# Logic error 3...
le3_wrong = """
for i in range(17):
  row, col, choices = state.random()
  value = numpy.random.choice(choices)
            
  puzzle[col*9 + row] = str(value)
"""

le3_right = """
for i in range(17):
  row, col, choices = state.random()
  value = numpy.random.choice(choices)
            
  puzzle[row*9 + col] = str(value)
"""

q1_07 = am.Question('1.07', 1)
q1_07.add(None, am.CodeDelta(le3_wrong, le3_right))
q1_07(notebook)


# Contract violation 2...
cv2_wrong = """
return puzzle, solutions[0], attempts
"""

cv2_right = """
return ''.join(puzzle), solutions[0], attempts
"""

q1_09 = am.Question('1.09', 1)
q1_09.add(None, am.CodeDelta(cv2_wrong, cv2_right))
q1_09(notebook)


## Visualisation bug...
vis_wrong = """
row, col, choices = state.random()
value = numpy.random.choice(choices)
puzzle[col*9 + row] = str(value)
"""

vis_right = """
row, col, choices = state.random()
value = numpy.random.choice(choices)
puzzle[row*9 + col] = str(value)
"""

q1_10 = am.Question('1.10', 1)
q1_10.add(None, am.CodeDelta(vis_wrong, vis_right))
q1_10(notebook)



# Q2 - solver test - hand mark only...
q2 = am.Question(2, 4)
q2.worth(None, 4)
q2.add(None, am.MrBean())
q2(notebook)



# Q3 - unit tests...
q3_works = am.Question('3.works', 2)
q3_works.worth(None, 2)
q3_works.add(None, am.MrBean())
q3_works(notebook)

q3_ut = am.Question('3.ut', 4)
q3_ut.worth(None, 4)
q3_ut.add(None, am.MrBean())
q3_ut(notebook)
