#! /usr/bin/env python3

import numpy
import automark2 as am



# Load code...
notebook = am.Notebook(cwd='../Software Technologies for Data Science/Labs/02 - Raytracing')



# Q1 - start of rays...
## Correct answer...
start = numpy.zeros((429, 1024, 3))
start[:, :, 0] = numpy.linspace(-0.5, 0.5, 1024)[None,:]
start[:, :, 1] = numpy.linspace(-0.5 * 429 / 1024, 0.5 * 429 / 1024, 429)[:,None]


## Mark...
q1 = am.Question(1, 2)

q1.worth(None, 2)
q1.add(None, am.All(am.CodeMatch(['start =']),
                    am.CodeMatch(['!', 'for, while']),
                    am.VarClose('start', start)))

q1(notebook)



# Q2 - direction of rays...
## Correct answer...
norm = start.copy()
norm -= numpy.array([0, 0, -24.0 / 36.0])[None,None,:]
norm /= numpy.sqrt(numpy.square(norm).sum(axis=2))[:,:,None]


## Mark...
q2 = am.Question(2, 2)

q2.worth(None, 2)
q2.add(None, am.All(am.CodeMatch(['norm =']),
                    am.CodeMatch(['!', 'for, while']),
                    am.VarClose('norm', norm)))

q2(notebook)



# Q3 - move and rotate into position...
## Correct answer...
start[:,:,2] -= 2.0 * (128 * 24.0) / 36

s = numpy.sin(numpy.pi * 30 / 180)
c = numpy.cos(numpy.pi * 30 / 180)
rot = numpy.array([[1.0, 0.0, 0.0],
                   [0.0,   c,   s],
                   [0.0,  -s,   c]])
start = numpy.einsum('yxc,rc->yxr', start, rot)
norm = numpy.einsum('yxc,rc->yxr', norm, rot)

s = numpy.sin(numpy.pi * 45 / 180)
c = numpy.cos(numpy.pi * 45 / 180)
rot = numpy.array([[  c, 0.0,   s],
                   [0.0, 1.0, 0.0],
                   [ -s, 0.0,   c]])
start = numpy.einsum('yxc,rc->yxr', start, rot)
norm = numpy.einsum('yxc,rc->yxr', norm, rot)


## Mark...
q3 = am.Question(3, 5)

q3.worth('correct', 4)
q3.add('correct', am.Uncertain(am.All(am.CodeMatch(['!', 'for, while']),
                                      am.VarClose('start', start),
                                      am.VarClose('norm', norm))))

q3.worth('einsum', 1)
q3.add('einsum', am.Any(am.CodeMatch(['start =', 'einsum()']),
                        am.CodeMatch(['norm =', 'einsum()'])))

q3(notebook)



# Q4 - firing rays...
## Right answer...
sdf = notebook.state()['sdf']

def sign_dist_nn(start, norm, travel):
    # Get position of ray end point...
    pos = start + travel[:,:,None] * norm
    
    # Convert to coordinate in sdf...
    pos = (pos + 0.5).astype(int)
    
    # Bounds check...
    pos[pos<0] = 0
    for d in range(3):
        pos[pos[:,:,d]>=sdf.shape[d],d] = sdf.shape[d] - 1
    
    # Index each to get the travel distance...
    ret = sdf[pos[:,:,0], pos[:,:,1], pos[:,:,2]]
    
    # Return...
    return ret


## Generate first few steps...
travel0 = numpy.zeros((429, 1024))
travel1 = sign_dist_nn(start, norm, travel0)
travel2 = sign_dist_nn(start, norm, travel1)
travel3 = sign_dist_nn(start, norm, travel2)


## Construct the question...
q4 = am.Question(4, 5)

q4.worth(None, 5)
q4.mode(None, 'all')

q4.add(None, am.CodeIterCap(6, 'sign_dist_nn', start, norm, travel0))
q4.add(None, am.FuncClose(travel1, 'sign_dist_nn', start, norm, travel0))
q4.add(None, am.FuncClose(travel2, 'sign_dist_nn', start, norm, travel1))
q4.add(None, am.FuncClose(travel3, 'sign_dist_nn', start, norm, travel2))

q4(notebook)



# Q5 - linear interpolation...
## Right answer...
def sign_dist_linear(start, norm, travel):
    # Get position of ray end point...
    pos = start + norm * travel[:,:,None]
    
    # Get integer version...
    base = pos.astype(int)
    
    # Bounds check integer version...
    base[base<0] = 0
    for d in range(3):
        base[base[:,:,d]>=(sdf.shape[d]-1),d] = sdf.shape[d] - 2
    
    # Create t array...
    t = numpy.clip(pos - base, 0.0, 1.0)
        
    # Create return array...
    ret = numpy.zeros(start.shape[:2])
    
    # Sum in the 8 corners of each ...
    for offsetz in range(2):
        for offsety in range(2):
            for offsetx in range(2):
                weight = numpy.ones(ret.shape)
                weight *= (1.0 - t[:,:,0]) if offsetz==0 else t[:,:,0]
                weight *= (1.0 - t[:,:,1]) if offsety==0 else t[:,:,1]
                weight *= (1.0 - t[:,:,2]) if offsetx==0 else t[:,:,2]
                
                ret += weight * sdf[base[:,:,0]+offsetz, base[:,:,1]+offsety, base[:,:,2]+offsetx]
    
    # Return...
    return ret


## Generate first few steps...
travel0 = numpy.zeros((429, 1024))
travel1 = sign_dist_linear(start, norm, travel0)
travel2 = sign_dist_linear(start, norm, travel1)
travel3 = sign_dist_linear(start, norm, travel2)


## Construct the question...
q5 = am.Question(5, 6)

q5.worth(None, 6)
q5.mode(None, 'all')

q5.add(None, am.CodeIterCap(32, 'sign_dist_linear', start, norm, travel0))
q5.add(None, am.FuncClose(travel1, 'sign_dist_linear', start, norm, travel0))
q5.add(None, am.FuncClose(travel2, 'sign_dist_linear', start, norm, travel1))
q5.add(None, am.FuncClose(travel3, 'sign_dist_linear', start, norm, travel2))

q5(notebook)
