#! /usr/bin/env python3

import automark

import re



# Load code...
injest = automark.InjestJupyter(automark.victim())



# Question 1...
q1 = automark.Question(1, 1)

q1.add(None, automark.MatchPrint(' | | \n | | \n | | \n', 'print_state', ((' ',' ',' '),(' ',' ',' '),(' ',' ',' '))))
q1.add(None, automark.MatchPrint('o|x|x\n |x|o\no|x| \n', 'print_state', (('o','x','x'),(' ','x','o'),('o','x',' '))))
q1.add(None, automark.MatchPrint('o|o|o\nx|x|x\n | | \n', 'print_state', (('o','o','o'),('x','x','x'),(' ',' ',' '))))
q1.add(None, automark.MatchPrint('x| |o\no| |x\nx| |o\n', 'print_state', (('x',' ','o'),('o',' ','x'),('x',' ','o'))))

q1(injest)



# Question 2...
q2 = automark.Question(2, 3)

q2.worth(None, 3)
q2.add(None, automark.Match(None, 'score_end', ((' ',' ',' '),
                                                (' ',' ',' '),
                                                (' ',' ',' '))))
q2.add(None, automark.Match(None, 'score_end', (('x',' ',' '),
                                                (' ','o',' '),
                                                ('o',' ','x'))))
q2.add(None, automark.Match(1, 'score_end', (('o',' ','o'),
                                             ('x','x','x'),
                                             (' ',' ',' '))))
q2.add(None, automark.Match(1, 'score_end', (('o','x','x'),
                                             (' ','x','o'),
                                             ('o','x',' '))))
q2.add(None, automark.Match(1, 'score_end', (('o','x','x'),
                                             (' ','x','o'),
                                             ('x','o',' '))))
q2.add(None, automark.Match(-1, 'score_end', (('o','x','x'),
                                              (' ','x','o'),
                                              ('o','o','o'))))
q2.add(None, automark.Match(-1, 'score_end', (('o','x',' '),
                                              ('o','x',' '),
                                              ('o',' ','x'))))
q2.add(None, automark.Match(-1, 'score_end', ((' ','x','o'),
                                              (' ','o','x'),
                                              ('o',' ','x'))))
q2.add(None, automark.Match(0, 'score_end', (('o','x','o'),
                                             ('x','x','o'),
                                             ('o','o','x'))))
q2.add(None, automark.Match(0, 'score_end', (('o','o','x'),
                                             ('x','o','o'),
                                             ('o','x','x'))))

q2(injest)



# Question 3...
q3 = automark.Question(3, 2)

seq0 = ((' ',' ',' '),(' ',' ',' '),(' ',' ',' '))
seq1 = ((' ',' ',' '),(' ',' ',' '),(' ','x',' '))
seq2 = (('o',' ',' '),(' ',' ',' '),(' ','x',' '))
seq3 = (('o',' ',' '),(' ','x',' '),(' ','x',' '))
seq4 = (('o','o',' '),(' ','x',' '),(' ','x',' '))
seq5 = (('o','o','x'),(' ','x',' '),(' ','x',' '))
seq6 = (('o','o','x'),(' ','x',' '),('o','x',' '))
seq7 = (('o','o','x'),('x','x',' '),('o','x',' '))
seq8 = (('o','o','x'),('x','x','o'),('o','x',' '))
seq9 = (('o','o','x'),('x','x','o'),('o','x','x'))

q3.worth(None, 2)
q3.add(None, automark.Match(seq1, 'play', seq0, 2, 1, 'x'))
q3.add(None, automark.Match(seq2, 'play', seq1, 0, 0, 'o'))
q3.add(None, automark.Match(seq3, 'play', seq2, 1, 1, 'x'))
q3.add(None, automark.Match(seq4, 'play', seq3, 0, 1, 'o'))
q3.add(None, automark.Match(seq5, 'play', seq4, 0, 2, 'x'))
q3.add(None, automark.Match(seq6, 'play', seq5, 2, 0, 'o'))
q3.add(None, automark.Match(seq7, 'play', seq6, 1, 0, 'x'))
q3.add(None, automark.Match(seq8, 'play', seq7, 1, 2, 'o'))
q3.add(None, automark.Match(seq9, 'play', seq8, 2, 2, 'x'))

q3(injest)



# Question 4...
q4 = automark.Question(4, 1)

moves0 = [(0, 0), (0, 1), (0, 2), (1, 0), (1, 1), (1, 2), (2, 0), (2, 1), (2, 2)]
moves3 = [(0, 1), (0, 2), (1, 0), (1, 2), (2, 0), (2, 2)]
moves6 = [(1, 0), (1, 2), (2, 2)]
moves9 = []

q4.add(None, automark.MatchUnordered(moves0, 'moves', seq0))
q4.add(None, automark.MatchUnordered(moves3, 'moves', seq3))
q4.add(None, automark.MatchUnordered(moves6, 'moves', seq6))
q4.add(None, automark.MatchUnordered(moves9, 'moves', seq9))

q4(injest)



# Question 5...
q5 = automark.Question(5, 3)

q5.worth(None, 3)
q5.add(None, automark.MatchPartial({0 : 0}, 'score', ((' ',' ',' '),(' ',' ',' '),(' ',' ',' ')), 'x'))
q5.add(None, automark.MatchPartial({0 : 1}, 'score', ((' ',' ',' '),(' ','x','o'),(' ',' ',' ')), 'x'))
q5.add(None, automark.MatchPartial({0 : 1}, 'score', (('x',' ',' '),(' ','x','o'),(' ',' ',' ')), 'o'))
q5.add(None, automark.MatchPartial({0 : -1}, 'score', (('o',' ',' '),('x',' ',' '),('o',' ',' ')), 'o'))

q5(injest)



# Question 6...
grid_re = re.compile(r'[ xo]\|[ xo]\|[ xo]\n[ xo]\|[ xo]\|[ xo]\n[ xo]\|[ xo]\|[ xo]')


def grid_str_to_tup(s):
  return ((s[0],  s[2],  s[4]),
          (s[6],  s[8],  s[10]),
          (s[12], s[14], s[16]))


def find_draw(injest):
  """Searches all cells of a loaded Jupyter notebook and returns True if it finds a game that ends in a draw."""
  for cell in injest.cells():
    # Fetch list of grids...
    grids = grid_re.findall(cell)
    grids = [grid_str_to_tup(s) for s in grids]
    
    # We allow the first grid to be omitted, so must be at least 9 shown or we are done...
    if len(grids)<9:
      continue
    
    # Check last grid is fully filled in and a draw...
    bad = False
    ## Full...
    if True in [' ' in row for row in grids[-1]]:
      bad = True
    
    ## No rows...
    for row in grids[-1]:
      if row[0]==row[1] and row[1]==row[2]:
        bad = True
    
    ## No columns...
    for c in range(3):
      if grids[-1][0][c]==grids[-1][1][c] and grids[-1][1][c]==grids[-1][2][c]:
        bad = True
    
    ## No diagonals...
    if grids[-1][0][0]==grids[-1][1][1] and grids[-1][1][1]==grids[-1][2][2]:
      bad = True
      
    if grids[-1][2][0]==grids[-1][1][1] and grids[-1][1][1]==grids[-1][0][2]:
      bad = True

    # Work through steps, making sure each grid is a valid move from the last (single space is replaced with a o or x)...
    for step in range(len(grids)-1):
      changes = 0
      for r in range(3):
        for c in range(3):
          if grids[step][r][c]!=grids[step+1][r][c]:
            changes += 1
            if grids[step][r][c]!=' ':
              bad = True

      if changes!=1:
        bad = True
        break

    # If failed move to next cell...
    if bad:
      continue
    
    # All tests passed - they did it!..
    return True
  
  return False


q6 = automark.Question(6, 3)
q6.worth(None, 3)
q6.add(None, find_draw)
q6(injest)



# Question 7 (arguably not a reliable check, but good enough)...
def cache_full(injest):
  if 'cache' not in injest:
    return False
  
  try:
    count = len(injest['cache'])
  except:
    print('Warning: cache has no length, type = {}'.format(type(injest['cache']).__name__))
    return False
  
  if count > 5000: # Should be 5702
    return True
  
  else:
    return False


q7 = automark.Question(7, 2)
q7.worth(None, 2)
q7.add(None, cache_full)
q7(injest)
