#! /usr/bin/env python3



# Storage for the vertices and faces...
verts = []
faces = []



# Code to generate and add a segment - all worked out from .blend file...
def add_segment(x, y, vertical):
  global verts
  global faces
  
  base = len(verts)
  
  def adjust(v): # This does a 90 degree rotation when vertical is True.
    if vertical:
      return [x+(v[1]-y),y-(v[0]-x),v[2],v[4],-v[3]]
    else:
      return v
  
  verts.append(adjust([x-0.19, y, 0.0, -1.0, 0.0]))
  verts.append(adjust([x-0.145, y+0.045, 0.0, -0.763, 1.0]))
  verts.append(adjust([x-0.145, y, 0.0, -0.763, 0.0]))
  verts.append(adjust([x-0.145, y-0.045, 0.0, -0.763, -1.0]))
  verts.append(adjust([x+0.145, y+0.045, 0.0, 0.763, 1.0]))
  verts.append(adjust([x+0.145, y, 0.0, 0.763, 0.0]))
  verts.append(adjust([x+0.145, y-0.045, 0.0, 0.763, -1.0]))
  verts.append(adjust([x+0.19, y, 0.0, 1.0, 0.0]))
  
  faces.append([base,base+2,base+1])
  faces.append([base,base+3,base+2])
  faces.append([base+1,base+2,base+5, base+4])
  faces.append([base+2,base+3,base+6, base+5])
  faces.append([base+4,base+5,base+7])
  faces.append([base+5,base+6,base+7])



# Code to generate and add a digit - same bit-segment assignment as example image...
def add_digit(x, y, bits):
  if bits&1: add_segment(x,y+0.4,False)
  if bits&2: add_segment(x+0.2,y+0.2,True)
  if bits&4: add_segment(x+0.2,y-0.2,True)
  if bits&8: add_segment(x,y-0.4,False)
  if bits&16: add_segment(x-0.2,y-0.2,True)
  if bits&32: add_segment(x-0.2,y+0.2,True)
  if bits&64: add_segment(x,y,False)



# Loop and generate every combo...
bits = 0
for ycell in range(128):
  ybase = -(ycell - 63.5) # 63.5 centers a 128x128 grid.
  for xcell in range(128):
    xbase = (xcell - 63.5) * 1.2 # 1.2=width of 2 digits
    
    add_digit(xbase-0.3, ybase, bits & (128-1))
    add_digit(xbase+0.3, ybase, (bits>>7) & (128-1))
    
    bits += 1



# Dump to a ply file...
fout = open('14bit.ply', 'w')

## Header...
fout.write('ply\n')
fout.write('format ascii 1.0\n')

fout.write('element vertex {}\n'.format(len(verts)))
fout.write('property float x\n')
fout.write('property float y\n')
fout.write('property float z\n')
fout.write('property float s\n')
fout.write('property float t\n')

fout.write('element face {}\n'.format(len(faces)))
fout.write('property list uchar int vertex_indices\n')

fout.write('end_header\n')

## Vertices...
for vert in verts:
  fout.write('{} {} {} {} {}\n'.format(*vert))

## Faces...
for face in faces:
  fout.write(('{}' + ' {}'*len(face)+'\n').format(len(face), *face))

## Done...
fout.close()
